/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.juancarloscp52.bedrockify.BedrockifySettings;
import me.juancarloscp52.bedrockify.common.block.cauldron.BedrockCauldronBehavior;
import me.juancarloscp52.bedrockify.common.features.cauldron.BedrockCauldronBlocks;
import me.juancarloscp52.bedrockify.common.features.worldGeneration.DyingTrees;
import me.juancarloscp52.bedrockify.common.payloads.CauldronParticlePayload;
import me.juancarloscp52.bedrockify.common.payloads.EatParticlePayload;
import me.juancarloscp52.bedrockify.mixin.featureManager.MixinFeatureManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bedrockify
implements ModInitializer {
    public static final String MOD_ID = "bedrockify";
    public static final Logger LOGGER = LogManager.getLogger();
    public BedrockifySettings settings;
    private static Bedrockify instance;
    public static final EatParticlePayload EAT_PARTICLE_PAYLOAD;
    public static final CauldronParticlePayload CAULDRON_PARTICLE_PAYLOAD;

    public static Bedrockify getInstance() {
        return instance;
    }

    public void onInitialize() {
        LOGGER.info("Initializing BedrockIfy.");
        this.loadSettings();
        instance = this;
        DyingTrees.registerTrees();
        PayloadTypeRegistry.playS2C().register(EAT_PARTICLE_PAYLOAD.method_56479(), EatParticlePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CAULDRON_PARTICLE_PAYLOAD.method_56479(), CauldronParticlePayload.CODEC);
        if (MixinFeatureManager.features.get("common.features.cauldron").booleanValue()) {
            BedrockCauldronBlocks.register();
            ServerLifecycleEvents.SERVER_STARTED.register(server -> BedrockCauldronBehavior.registerBehavior());
        }
    }

    public void loadSettings() {
        File file = new File("./config/bedrockify/bedrockifyCommon.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (BedrockifySettings)gson.fromJson((Reader)fileReader, BedrockifySettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load bedrockIfy settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new BedrockifySettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/bedrockify/bedrockifyCommon.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save bedrockIfy settings: " + e.getLocalizedMessage());
        }
    }

    static {
        EAT_PARTICLE_PAYLOAD = new EatParticlePayload();
        CAULDRON_PARTICLE_PAYLOAD = new CauldronParticlePayload();
    }
}

